﻿using System;
using System.Linq;

namespace VIRP.EFR.BO
{
    [Serializable]
    public class Letter : Address
    {
        public string InterpretationText { get; set; }

        public string LastName
        {
            get
            {
                return GetLastName(Name);
            }
        }

        public string Gender { get; set; }

        public string GetLastName(string fullName)
        {
            string[] Names = fullName.Split(new char[] { ',' });
            return Names.Where(e => (e.Trim() != "" && e != null)).FirstOrDefault();
        }

        public string PatientLastName { get; set; }
        public string Last4SSN { get; set; }
        public string WorkflowType { get; set; }
    }
}
